L=6000;bw=200;Ef=150000;efu=0.0117;ffu=Ef*efu;fc=26;b1=0.8;ecu=0.0035;Ec=28000;w=15;%basic parameters of the beam
%calculate the middle section of the beam based on flexual capacity%
syms x d Af
[Af,d,x]=solve(b1*fc*bw*x==Af*ffu, b1*fc*bw*x*(d-x/2)==w*L^2/8, x*efu==(d-x)*ecu);
Af=Af(Af>0);
x=x(x>0);
d=d(d>0);
Af=eval(Af);
x=eval(x);
d=eval(d);

%the calculation depth of each section
y1=linspace(2970,30,99);%the calculation section
y2=linspace(2985,15,100);%comparison sections

M1=sym('M1',[1 99]);%Moment applied on the section%
V1=sym('V1',[1 99]);%shear force applied%
av1=sym('av1',[1 99]);%shear span of the section=M/V%
Of1=sym('Of1',[1 99]);%the strain of the frp reinforcement%
D1=sym('D1',[1 99]);%the depth of the sections%
X1=sym('X1',[1 99]);%the depth of compression zone of the section%
for i=1:99,
    M1(i)=0.5*w*y1(i)*(L-y1(i));
    V1(i)=0.5*w*L-w*y1(i);
    av1(i)=M1(i)/V1(i);
    [D1(i),Of1(i),X1(i)]=solve(b1*fc*bw*X1(i)==Af*Of1(i), b1*fc*bw*X1(i)*(D1(i)-X1(i)/2)==M1(i), X1(i)*Of1(i)/Ef==(D1(i)-X1(i))*ecu);
end 

D1=eval(D1);
M1=eval(M1);
V1=eval(V1);

M2=sym('M2',[1 100]);%Moment applied on the section%
V2=sym('V2',[1 100]);%shear force applied%
av2=sym('av2',[1 100]);%shear span of the section=M/V%
Of2=sym('Of2',[1 100]);%the strain of the frp reinforcement%
D2=sym('D2',[1 100]);%the depth of the sections%
X2=sym('X2',[1 100]);%the depth of compression zone of the section%
for i=1:100,
    M2(i)=0.5*w*y2(i)*(L-y2(i));
    V2(i)=0.5*w*L-w*y2(i);
    av2(i)=M2(i)/V2(i);
    [D2(i),Of2(i),X2(i)]=solve(b1*fc*bw*X2(i)==Af*Of2(i), b1*fc*bw*X2(i)*(D2(i)-X2(i)/2)==M2(i), X2(i)*Of2(i)/Ef==(D2(i)-X2(i))*ecu);
end 

D2=eval(D2);
M2=eval(M2);
V2=eval(V2);

c=0.8;%the parameter for the load

%calculate the N.A of comparison sections
xc=sym('xc',[1 100]); 
oc=sym('oc',[1 100]);
ec=sym('ec',[1 100]);
ef=sym('ef',[1 100]);
T2=sym('T2',[1 100]);
%calculation of the inclination
k=sym('k',[1 99]);
dy=30;
for i=1:99,
    k(i)=(D2(i)-D2(i+1))/dy;
end
k=eval(k);

for i=1:100,
    
    k1=D2(i);k2=c*M2(i);
   
    p=fsolve(@(p) crack(p,k1,k2),[50;30;0.003;0.01],optimset('MaxFunEvals',100000,'MaxIter',100000));
    xc(i)=p(1);oc(i)=p(2);ec(i)=p(3);ef(i)=p(4);
    T2(i)=ef(i)*Af*Ef;% the tensile force of frp
end

xc=eval(xc);
oc=eval(oc);
ec=eval(ec);
ef=eval(ef);

%the effective shear force of the calculation sections
T=sym('T',[1 99]);
dTv=sym('dTv',[1 99]);
Tv=sym('Tv',[1 99]);
Ve=sym('Ve',[1 99]);
for i=1:99,
    T(i)=(T2(i)+T2(i+1))/2;
    dTv(i)=(T2(i)-T2(i+1));%The difference force in frp 
    Tv(i)=T(i)*k(i);
    Ve(i)=c*V1(i)-Tv(i);
end
%effective shear force method: the calculation moment
Me=sym('Me',[2 99]);
for i=1:99,
   Me(1,i)=c*M1(i)+Ve(i)*dy/2;
   Me(2,i)=c*M1(i)-Ve(i)*dy/2;
end
T=eval(T);
Tv=eval(Tv);
dTv=eval(dTv);
Ve=eval(Ve);
Me=eval(Me);

%the effective shear force method
xce=sym('xc',[3 99]); 
oce=sym('oc',[3 99]);
ece=sym('ec',[3 99]);
efe=sym('ef',[3 99]);

for i=1:99,
    
    k1=D1(i);k2=Me(1,i);
    
    p=fsolve(@(p) crack(p,k1,k2),[50;25;0.003;0.01],optimset('MaxFunEvals',100000,'MaxIter',100000));
    xce(1,i)=p(1);oce(1,i)=p(2);ece(1,i)=p(3);efe(1,i)=p(4);
end
for i=1:99,
    
    k1=D1(i);k2=Me(2,i);
    %set the max iteration as 10000
    p=fsolve(@(p) crack(p,k1,k2),[50;25;0.003;0.01],optimset('MaxFunEvals',100000,'MaxIter',100000));
    xce(2,i)=p(1);oce(2,i)=p(2);ece(2,i)=p(3);efe(2,i)=p(4);
end
for i=1:99,
    
    k1=D1(i);k2=c*M1(i);
   
    p=fsolve(@(p) crack(p,k1,k2),[50;25;0.003;0.01],optimset('MaxFunEvals',100000,'MaxIter',100000));
    xce(3,i)=p(1);oce(3,i)=p(2);ece(3,i)=p(3);efe(3,i)=p(4);
end
xce=eval(xce);
oce=eval(oce);
ece=eval(ece);
efe=eval(efe);



z=sym('z',[501 99]);
%divide the sections
for i=1:99,
    for j=1:501,
        z(j,i)=D1(i)*(j-1)/500;
    end
end
z=eval(z);
%the normal stress calculation of variable and non-inclined sections
ocn1=sym('ocn1',[501 99]);
ocn2=sym('ocn2',[501 99]);
ocne1=sym('ocnp',[501 99]);
ocne2=sym('ocnp',[501 99]);

ecn1=sym('ecn1',[501 99]);
ecn2=sym('ecn2',[501 99]);
ecne1=sym('ecnp',[501 99]);
ecne2=sym('ecnp',[501 99]);
for i=1:99,
    for j=1:501,
        if z(j,i)<=xc(i),
            ecn1(j,i)=ec(i)*(1-z(j,i)/xc(i));
            ocn1(j,i)=ecn1(j,i)*fc/ecu*1.5;
        else
           ecn1(j,i)=0; 
           ocn1(j,i)=0;
        end
        if z(j,i)<=xc(i+1),
            ecn2(j,i)=ec(i+1)*(1-z(j,i)/xc(i+1));
            ocn2(j,i)=ecn2(j,i)*fc/ecu*1.5;
        else
           ecn2(j,i)=0; 
           ocn2(j,i)=0;
        end
        if z(j,i)<=xce(1,i),
            ecne1(j,i)=ece(1,i)*(1-z(j,i)/xce(1,i));
            ocne1(j,i)=ecne1(j,i)*fc/ecu*1.5;
        else
           ecne1(j,i)=0; 
           ocne1(j,i)=0;
        end
        if z(j,i)<=xce(2,i),
            ecne2(j,i)=ece(2,i)*(1-z(j,i)/xce(2,i));
            ocne2(j,i)=ecne2(j,i)*fc/ecu*1.5;
        else
           ecne2(j,i)=0; 
           ocne2(j,i)=0;
        end
    end
end    
ocn1=eval(ocn1);
ocn2=eval(ocn2);
ocne1=eval(ocne1);
ocne2=eval(ocne2);
ecn1=eval(ecn1);
ecn2=eval(ecn2);
ecne1=eval(ecne1);
ecne2=eval(ecne2);

%calculate the difference of normal stress at each point
docn=sym('docn',[501 99]);
doce=sym('doce',[501 99]);
for i=1:99
    for j=1:501,
        docn(j,i)=ocn1(j,i)-ocn2(j,i);
        doce(j,i)=ocne1(j,i)-ocne2(j,i);
    end
end
docn=eval(docn);
doce=eval(doce);



%calculate the shear stress at each point
txy=sym('txy',[501 99]);
txye=sym('txye',[501 99]);

for i=1:99,
    txy(1,i)=0;
    txye(1,i)=0;
    for j=2:501,
        if z(j,i)<D2(i+1),
            txy(j,i)=docn(j,i)*D1(i)/500/dy+txy(j-1,i);
        else
            txy(j,i)=docn(j,i)*D1(i)/500/dy-(z(j,i)-z(j-1,i))/(D2(i)-D2(i+1))*dTv(i)/bw/dy+txy(j-1,i);
        end
            
            txye(j,i)=doce(j,i)*D1(i)/500/dy+txye(j-1,i);
    end
end

txy=eval(txy);
txye=eval(txye);

%calculation of the difference of shear force upon frp


